
# This file is part of fbget: Python wrappers for the firebrowse RESTful api
# Autogenerated on 2017_10_31 20:30:56 EDT

__version__ = '0.1.10'

SupportedParameters = {   #  {{{
'cde' : {   'alias': 'cde',
    'default': None,
    'multiValued': True,
    'name': u'cde_name',
    'values': [   u'Retrieve results only for specified CDEs, per the Metadata/ClinicalNames function']},
'code' : {   'alias': u'code',
    'default': None,
    'multiValued': True,
    'name': u'code',
    'values': [   u'01',
                  u'03',
                  u'07',
                  u'09',
                  u'12',
                  u'20',
                  u'40',
                  u'02',
                  u'04',
                  u'05',
                  u'06',
                  u'08',
                  u'10',
                  u'11',
                  u'13',
                  u'14',
                  u'50',
                  u'60',
                  u'61']},
'protocol' : {   'alias': u'protocol',
    'default': u'RSEM',
    'multiValued': True,
    'name': u'protocol',
    'values': [u'RPKM', u'RSEM']},
'rank' : {   'alias': u'rank',
    'default': None,
    'multiValued': False,
    'name': u'rank',
    'values': [u'Number of significant genes to return.']},
'page_size' : {   'alias': u'page_size',
    'default': 250,
    'multiValued': True,
    'name': u'page_size',
    'values': [u'Number of records per page of results.  Max is 2000.']},
'short_letter_code' : {   'alias': u'short_letter_code',
    'default': None,
    'multiValued': True,
    'name': u'short_letter_code',
    'values': [   u'TP',
                  u'TB',
                  u'TAM',
                  u'TBM',
                  u'NBC',
                  u'CELLC',
                  u'TRB',
                  u'TR',
                  u'TRBM',
                  u'TAP',
                  u'TM',
                  u'THOC',
                  u'NB',
                  u'NT',
                  u'NEBV',
                  u'NBM',
                  u'CELL',
                  u'XP',
                  u'XCL']},
'totals' : {   'alias': u'totals',
    'default': True,
    'multiValued': False,
    'name': u'totals',
    'values': [u'Output an entry providing the totals for each data type.']},
'cohort' : {   'alias': u'cohort',
    'default': None,
    'multiValued': True,
    'name': u'cohort',
    'values': [   u'ACC',
                  u'BLCA',
                  u'BRCA',
                  u'CESC',
                  u'CHOL',
                  u'COAD',
                  u'COADREAD',
                  u'DLBC',
                  u'ESCA',
                  u'FPPP',
                  u'GBM',
                  u'GBMLGG',
                  u'HNSC',
                  u'KICH',
                  u'KIPAN',
                  u'KIRC',
                  u'KIRP',
                  u'LAML',
                  u'LGG',
                  u'LIHC',
                  u'LUAD',
                  u'LUSC',
                  u'MESO',
                  u'OV',
                  u'PAAD',
                  u'PCPG',
                  u'PRAD',
                  u'READ',
                  u'SARC',
                  u'SKCM',
                  u'STAD',
                  u'STES',
                  u'TGCT',
                  u'THCA',
                  u'THYM',
                  u'UCEC',
                  u'UCS',
                  u'UVM']},
'TCGA_Barcode' : {   'alias': u'TCGA_Barcode',
    'default': None,
    'multiValued': False,
    'name': u'TCGA_Barcode',
    'values': [   u'Enter a single TCGA barcode, of any form: e.g. TCGA-GF-A4EO-06 or TCGA-EL-A3D5-01A-22D-A202-08']},
'sample_type' : {   'alias': u'sample_type',
    'default': None,
    'multiValued': True,
    'name': u'sample_type',
    'values': [   u'NB',
                  u'NBC',
                  u'NBM',
                  u'NT',
                  u'TAM',
                  u'TAP',
                  u'TB',
                  u'TM',
                  u'TP',
                  u'TR']},
'center' : {   'alias': u'center',
    'default': None,
    'multiValued': True,
    'name': u'center',
    'values': [   u'bcgsc.ca',
                  u'broad.mit.edu',
                  u'broadinstitute.org',
                  u'genome.wustl.edu',
                  u'hgsc.bcm.edu',
                  u'hms.harvard.edu',
                  u'hudsonalpha.org',
                  u'intgen.org',
                  u'jhu-usc.edu',
                  u'jhu.edu',
                  u'lbl.gov',
                  u'mdanderson.org',
                  u'mskcc.org',
                  u'nationwidechildrens.org',
                  u'pnl.gov',
                  u'rubicongenomics.com',
                  u'sanger.ac.uk',
                  u'systemsbiology.org',
                  u'ucsc.edu',
                  u'unc.edu',
                  u'vanderbilt.edu']},
'platform' : {   'alias': u'platform',
    'default': None,
    'multiValued': True,
    'name': u'platform',
    'values': [   u'454',
                  u'ABI',
                  u'AgilentG4502A_07',
                  u'AgilentG4502A_07_1',
                  u'AgilentG4502A_07_2',
                  u'AgilentG4502A_07_3',
                  u'bio',
                  u'biotab',
                  u'CGH-1x1M_G4447A',
                  u'diagnostic_images',
                  u'fh_analyses',
                  u'fh_reports',
                  u'fh_stddata',
                  u'Genome_Wide_SNP_6',
                  u'GenomeWideSNP_5',
                  u'H-miRNA_8x15K',
                  u'H-miRNA_8x15Kv2',
                  u'H-miRNA_EarlyAccess',
                  u'H-miRNA_G4470A',
                  u'HG-CGH-244A',
                  u'HG-CGH-415K_G4124A',
                  u'HG-U133_Plus_2',
                  u'HG-U133A_2',
                  u'HT_HG-U133A',
                  u'HuEx-1_0-st-v2',
                  u'Human1MDuo',
                  u'HumanHap550',
                  u'HumanMethylation27',
                  u'HumanMethylation450',
                  u'IlluminaDNAMethylation_OMA002_CPI',
                  u'IlluminaDNAMethylation_OMA003_CPI',
                  u'IlluminaGA_DNASeq',
                  u'IlluminaGA_DNASeq_automated',
                  u'IlluminaGA_DNASeq_Cont',
                  u'IlluminaGA_DNASeq_Cont_automated',
                  u'IlluminaGA_DNASeq_Cont_curated',
                  u'IlluminaGA_DNASeq_curated',
                  u'IlluminaGA_miRNASeq',
                  u'IlluminaGA_mRNA_DGE',
                  u'IlluminaGA_RNASeq',
                  u'IlluminaGA_RNASeqV2',
                  u'IlluminaGG',
                  u'IlluminaHiSeq_DNASeq',
                  u'IlluminaHiSeq_DNASeq_automated',
                  u'IlluminaHiSeq_DNASeq_Cont',
                  u'IlluminaHiSeq_DNASeq_Cont_automated',
                  u'IlluminaHiSeq_DNASeq_Cont_curated',
                  u'IlluminaHiSeq_DNASeq_curated',
                  u'IlluminaHiSeq_DNASeqC',
                  u'IlluminaHiSeq_miRNASeq',
                  u'IlluminaHiSeq_mRNA_DGE',
                  u'IlluminaHiSeq_RNASeq',
                  u'IlluminaHiSeq_RNASeqV2',
                  u'IlluminaHiSeq_TotalRNASeqV2',
                  u'IlluminaHiSeq_WGBS',
                  u'Mapping250K_Nsp',
                  u'Mapping250K_Sty',
                  u'MDA_RPPA_Core',
                  u'microsat_i',
                  u'minbio',
                  u'minbiotab',
                  u'Mixed_DNASeq',
                  u'Mixed_DNASeq_automated',
                  u'Mixed_DNASeq_Cont',
                  u'Mixed_DNASeq_Cont_automated',
                  u'Mixed_DNASeq_Cont_curated',
                  u'Mixed_DNASeq_curated',
                  u'pathology_reports',
                  u'SOLiD_DNASeq',
                  u'SOLiD_DNASeq_automated',
                  u'SOLiD_DNASeq_Cont',
                  u'SOLiD_DNASeq_Cont_automated',
                  u'SOLiD_DNASeq_Cont_curated',
                  u'SOLiD_DNASeq_curated',
                  u'tissue_images',
                  u'WHG-1x44K_G4112A',
                  u'WHG-4x44K_G4112F',
                  u'WHG-CGH_4x44B']},
'mir' : {   'alias': u'mir',
    'default': None,
    'multiValued': True,
    'name': u'mir',
    'values': [   u'Comma separated list of miR names (e.g. hsa-let-7b-5p,hsa-let-7a-1).']},
'type' : {   'alias': u'type',
    'default': None,
    'multiValued': True,
    'name': u'type',
    'values': [   u'Aggregate',
                  u'Clustering',
                  u'CopyNumber',
                  u'Correlations',
                  u'Expression',
                  u'Mutation',
                  u'Pathway']},
'data_type' : {   'alias': u'data_type',
    'default': None,
    'multiValued': True,
    'name': u'data_type',
    'values': [   u'Clinical',
                  u'CopyNumber',
                  u'LowPass',
                  u'MAF',
                  u'Methylation',
                  u'miR',
                  u'miRSeq',
                  u'mRNA',
                  u'mRNASeq',
                  u'rawMAF',
                  u'rawWIG',
                  u'RPPA',
                  u'WIG']},
'format' : {   'alias': u'format',
    'default': u'json',
    'multiValued': False,
    'name': u'format',
    'values': [u'json', u'tsv', u'csv']},
'tool' : {   'alias': u'tool',
    'default': u'miRseq_Mature_Preprocess',
    'multiValued': True,
    'name': u'tool',
    'values': [u'miRseq_Mature_Preprocess', u'miRseq_Preprocess']},
'barcode' : {   'alias': 'barcode',
    'default': None,
    'multiValued': True,
    'name': u'tcga_participant_barcode',
    'values': [   u'Comma separated list of TCGA participant barcodes (e.g. TCGA-GF-A4EO).']},
'date' : {   'alias': u'date',
    'default': u'2016_01_28',
    'multiValued': True,
    'name': u'date',
    'values': [   u'2016_01_28',
                  u'2015_08_21',
                  u'2015_04_02',
                  u'2014_10_17',
                  u'2014_07_15',
                  u'2014_04_16',
                  u'2014_01_15',
                  u'2013_09_23',
                  u'2013_05_23',
                  u'2013_04_21']},
'fh_cde' : {   'alias': 'fh_cde',
    'default': None,
    'multiValued': True,
    'name': u'fh_cde_name',
    'values': [   u'age_at_diagnosis',
                  u'age_began_smoking_in_years',
                  u'Breslow_thickness',
                  u'cause_of_death',
                  u'cervical_carcinoma_pelvic_extension_text',
                  u'cervix_suv_results',
                  u'chemo_concurrent_type',
                  u'clinical_stage',
                  u'corpus_involvement',
                  u'date_of_initial_pathologic_diagnosis',
                  u'days_to_death',
                  u'days_to_last_followup',
                  u'days_to_last_known_alive',
                  u'days_to_psa',
                  u'days_to_submitted_specimen_dx',
                  u'ethnicity',
                  u'extrathyroidal_extension',
                  u'gender',
                  u'gleason_score',
                  u'height_cm_at_diagnosis',
                  u'histological_type',
                  u'history_hormonal_contraceptives_use',
                  u'hysterectomy_type',
                  u'initial_pathologic_dx_year',
                  u'karnofsky_performance_score',
                  u'keratinization_squamous_cell',
                  u'lymph_node_location',
                  u'lymph_nodes_examined',
                  u'lymph_nodes_examined_he_count',
                  u'lymphovascular_involvement',
                  u'melanoma_primary_known',
                  u'melanoma_ulceration',
                  u'menopause_status',
                  u'multifocality',
                  u'neoplasm_histologic_grade',
                  u'number_of_lymph_nodes',
                  u'number_pack_years_smoked',
                  u'pathologic_stage',
                  u'pathology_M_stage',
                  u'pathology_N_stage',
                  u'pathology_T_stage',
                  u'pos_lymph_node_location',
                  u'pregnancies_count_ectopic',
                  u'pregnancies_count_live_birth',
                  u'pregnancies_count_stillbirth',
                  u'pregnancies_count_total',
                  u'pregnancy_spontaneous_abortion_count',
                  u'pregnancy_therapeutic_abortion_count',
                  u'psa_value',
                  u'race',
                  u'radiation_exposure',
                  u'radiation_therapy',
                  u'radiation_therapy_status',
                  u'residual_tumor',
                  u'tobacco_smoking_history',
                  u'tobacco_smoking_pack_years_smoked',
                  u'tobacco_smoking_year_stopped',
                  u'tumor_size',
                  u'tumor_stage',
                  u'tumor_status',
                  u'tumor_tissue_site',
                  u'vital_status',
                  u'weight_kg_at_diagnosis',
                  u'year_of_tobacco_smoking_onset',
                  u'years_to_birth']},
'tss_code' : {   'alias': u'tss_code',
    'default': None,
    'multiValued': True,
    'name': u'tss_code',
    'values': [   u'01',
                  u'02',
                  u'04',
                  u'05',
                  u'06',
                  u'07',
                  u'08',
                  u'09',
                  u'10',
                  u'11',
                  u'12',
                  u'13',
                  u'14',
                  u'15',
                  u'16',
                  u'17',
                  u'18',
                  u'19',
                  u'1Z',
                  u'20',
                  u'21',
                  u'22',
                  u'23',
                  u'24',
                  u'25',
                  u'26',
                  u'27',
                  u'28',
                  u'29',
                  u'2A',
                  u'2E',
                  u'2F',
                  u'2G',
                  u'2H',
                  u'2J',
                  u'2K',
                  u'2L',
                  u'2M',
                  u'2N',
                  u'2P',
                  u'2V',
                  u'2W',
                  u'2X',
                  u'2Y',
                  u'2Z',
                  u'30',
                  u'31',
                  u'32',
                  u'33',
                  u'34',
                  u'35',
                  u'36',
                  u'37',
                  u'38',
                  u'39',
                  u'3A',
                  u'3B',
                  u'3C',
                  u'3E',
                  u'3G',
                  u'3H',
                  u'3J',
                  u'3K',
                  u'3L',
                  u'3M',
                  u'3N',
                  u'3P',
                  u'3Q',
                  u'3R',
                  u'3S',
                  u'3T',
                  u'3U',
                  u'3W',
                  u'3X',
                  u'3Z',
                  u'41',
                  u'42',
                  u'43',
                  u'44',
                  u'46',
                  u'49',
                  u'4A',
                  u'4B',
                  u'4C',
                  u'4D',
                  u'4E',
                  u'4G',
                  u'4H',
                  u'4J',
                  u'4K',
                  u'4L',
                  u'4N',
                  u'4P',
                  u'4Q',
                  u'4R',
                  u'4S',
                  u'4T',
                  u'4V',
                  u'4W',
                  u'4X',
                  u'4Y',
                  u'4Z',
                  u'50',
                  u'51',
                  u'52',
                  u'53',
                  u'55',
                  u'56',
                  u'57',
                  u'58',
                  u'59',
                  u'5A',
                  u'5B',
                  u'5C',
                  u'5D',
                  u'5F',
                  u'5G',
                  u'5H',
                  u'5J',
                  u'5K',
                  u'5L',
                  u'5M',
                  u'5N',
                  u'5P',
                  u'5Q',
                  u'5R',
                  u'5S',
                  u'5T',
                  u'5U',
                  u'5V',
                  u'5W',
                  u'5X',
                  u'60',
                  u'61',
                  u'62',
                  u'63',
                  u'64',
                  u'65',
                  u'66',
                  u'67',
                  u'68',
                  u'69',
                  u'6A',
                  u'6D',
                  u'6G',
                  u'6H',
                  u'70',
                  u'71',
                  u'72',
                  u'73',
                  u'74',
                  u'75',
                  u'76',
                  u'77',
                  u'78',
                  u'79',
                  u'80',
                  u'81',
                  u'82',
                  u'83',
                  u'85',
                  u'86',
                  u'87',
                  u'90',
                  u'91',
                  u'92',
                  u'93',
                  u'94',
                  u'95',
                  u'96',
                  u'97',
                  u'98',
                  u'99',
                  u'A1',
                  u'A2',
                  u'A3',
                  u'A4',
                  u'A5',
                  u'A6',
                  u'A7',
                  u'A8',
                  u'AA',
                  u'AB',
                  u'AC',
                  u'AD',
                  u'AF',
                  u'AG',
                  u'AH',
                  u'AJ',
                  u'AK',
                  u'AL',
                  u'AM',
                  u'AN',
                  u'AO',
                  u'AP',
                  u'AQ',
                  u'AR',
                  u'AS',
                  u'AT',
                  u'AU',
                  u'AV',
                  u'AW',
                  u'AX',
                  u'AY',
                  u'AZ',
                  u'B0',
                  u'B1',
                  u'B2',
                  u'B3',
                  u'B4',
                  u'B5',
                  u'B6',
                  u'B7',
                  u'B8',
                  u'B9',
                  u'BA',
                  u'BB',
                  u'BC',
                  u'BD',
                  u'BF',
                  u'BG',
                  u'BH',
                  u'BI',
                  u'BJ',
                  u'BK',
                  u'BL',
                  u'BM',
                  u'BP',
                  u'BQ',
                  u'BR',
                  u'BS',
                  u'BT',
                  u'BW',
                  u'C4',
                  u'C5',
                  u'C8',
                  u'C9',
                  u'CA',
                  u'CB',
                  u'CC',
                  u'CD',
                  u'CE',
                  u'CF',
                  u'CG',
                  u'CH',
                  u'CI',
                  u'CJ',
                  u'CK',
                  u'CL',
                  u'CM',
                  u'CN',
                  u'CQ',
                  u'CR',
                  u'CS',
                  u'CU',
                  u'CV',
                  u'CW',
                  u'CX',
                  u'CZ',
                  u'D1',
                  u'D3',
                  u'D5',
                  u'D6',
                  u'D7',
                  u'D8',
                  u'D9',
                  u'DA',
                  u'DB',
                  u'DC',
                  u'DD',
                  u'DE',
                  u'DF',
                  u'DG',
                  u'DH',
                  u'DI',
                  u'DJ',
                  u'DK',
                  u'DM',
                  u'DO',
                  u'DQ',
                  u'DR',
                  u'DS',
                  u'DT',
                  u'DU',
                  u'DV',
                  u'DW',
                  u'DX',
                  u'DY',
                  u'DZ',
                  u'E1',
                  u'E2',
                  u'E3',
                  u'E5',
                  u'E6',
                  u'E7',
                  u'E8',
                  u'E9',
                  u'EA',
                  u'EB',
                  u'EC',
                  u'ED',
                  u'EE',
                  u'EF',
                  u'EI',
                  u'EJ',
                  u'EK',
                  u'EL',
                  u'EM',
                  u'EO',
                  u'EP',
                  u'EQ',
                  u'ER',
                  u'ES',
                  u'ET',
                  u'EU',
                  u'EV',
                  u'EW',
                  u'EX',
                  u'EY',
                  u'EZ',
                  u'F1',
                  u'F2',
                  u'F4',
                  u'F5',
                  u'F6',
                  u'F7',
                  u'F9',
                  u'FA',
                  u'FB',
                  u'FC',
                  u'FD',
                  u'FE',
                  u'FF',
                  u'FG',
                  u'FH',
                  u'FI',
                  u'FJ',
                  u'FK',
                  u'FL',
                  u'FM',
                  u'FN',
                  u'FP',
                  u'FQ',
                  u'FR',
                  u'FS',
                  u'FT',
                  u'FU',
                  u'FV',
                  u'FW',
                  u'FX',
                  u'FY',
                  u'FZ',
                  u'G2',
                  u'G3',
                  u'G4',
                  u'G5',
                  u'G6',
                  u'G7',
                  u'G8',
                  u'G9',
                  u'GC',
                  u'GD',
                  u'GE',
                  u'GF',
                  u'GG',
                  u'GH',
                  u'GI',
                  u'GJ',
                  u'GK',
                  u'GL',
                  u'GM',
                  u'GN',
                  u'GP',
                  u'GR',
                  u'GS',
                  u'GU',
                  u'GV',
                  u'GZ',
                  u'H1',
                  u'H2',
                  u'H3',
                  u'H4',
                  u'H5',
                  u'H6',
                  u'H7',
                  u'H8',
                  u'H9',
                  u'HA',
                  u'HB',
                  u'HC',
                  u'HD',
                  u'HE',
                  u'HF',
                  u'HG',
                  u'HH',
                  u'HI',
                  u'HJ',
                  u'HK',
                  u'HL',
                  u'HM',
                  u'HN',
                  u'HP',
                  u'HQ',
                  u'HR',
                  u'HS',
                  u'HT',
                  u'HU',
                  u'HV',
                  u'HW',
                  u'HZ',
                  u'IA',
                  u'IB',
                  u'IC',
                  u'IE',
                  u'IF',
                  u'IG',
                  u'IH',
                  u'IJ',
                  u'IK',
                  u'IM',
                  u'IN',
                  u'IP',
                  u'IQ',
                  u'IR',
                  u'IS',
                  u'IW',
                  u'IZ',
                  u'J1',
                  u'J2',
                  u'J4',
                  u'J7',
                  u'J8',
                  u'J9',
                  u'JA',
                  u'JL',
                  u'JU',
                  u'JV',
                  u'JW',
                  u'JX',
                  u'JY',
                  u'JZ',
                  u'K1',
                  u'K4',
                  u'K6',
                  u'K7',
                  u'K8',
                  u'KA',
                  u'KB',
                  u'KC',
                  u'KD',
                  u'KE',
                  u'KF',
                  u'KG',
                  u'KH',
                  u'KJ',
                  u'KK',
                  u'KL',
                  u'KM',
                  u'KN',
                  u'KO',
                  u'KP',
                  u'KQ',
                  u'KR',
                  u'KS',
                  u'KT',
                  u'KU',
                  u'KV',
                  u'KZ',
                  u'L1',
                  u'L3',
                  u'L4',
                  u'L5',
                  u'L6',
                  u'L7',
                  u'L8',
                  u'L9',
                  u'LA',
                  u'LB',
                  u'LC',
                  u'LD',
                  u'LG',
                  u'LH',
                  u'LI',
                  u'LK',
                  u'LL',
                  u'LN',
                  u'LP',
                  u'LQ',
                  u'LS',
                  u'LT',
                  u'M7',
                  u'M8',
                  u'M9',
                  u'MA',
                  u'MB',
                  u'ME',
                  u'MF',
                  u'MG',
                  u'MH',
                  u'MI',
                  u'MJ',
                  u'MK',
                  u'ML',
                  u'MM',
                  u'MN',
                  u'MO',
                  u'MP',
                  u'MQ',
                  u'MR',
                  u'MS',
                  u'MT',
                  u'MU',
                  u'MV',
                  u'MW',
                  u'MX',
                  u'MY',
                  u'MZ',
                  u'N1',
                  u'N5',
                  u'N6',
                  u'N7',
                  u'N8',
                  u'N9',
                  u'NA',
                  u'NB',
                  u'NC',
                  u'ND',
                  u'NF',
                  u'NG',
                  u'NH',
                  u'NI',
                  u'NJ',
                  u'NK',
                  u'NM',
                  u'NP',
                  u'NQ',
                  u'NS',
                  u'O1',
                  u'O2',
                  u'O8',
                  u'O9',
                  u'OC',
                  u'OD',
                  u'OE',
                  u'OJ',
                  u'OK',
                  u'OL',
                  u'OR',
                  u'OU',
                  u'OW',
                  u'OX',
                  u'OY',
                  u'P3',
                  u'P4',
                  u'P5',
                  u'P6',
                  u'P7',
                  u'P8',
                  u'P9',
                  u'PA',
                  u'PB',
                  u'PC',
                  u'PD',
                  u'PE',
                  u'PG',
                  u'PH',
                  u'PJ',
                  u'PK',
                  u'PL',
                  u'PN',
                  u'PQ',
                  u'PR',
                  u'PT',
                  u'PZ',
                  u'Q1',
                  u'Q2',
                  u'Q3',
                  u'Q4',
                  u'Q9',
                  u'QA',
                  u'QB',
                  u'QC',
                  u'QD',
                  u'QF',
                  u'QG',
                  u'QH',
                  u'QJ',
                  u'QK',
                  u'QL',
                  u'QM',
                  u'QN',
                  u'QQ',
                  u'QR',
                  u'QS',
                  u'QT',
                  u'QU',
                  u'QV',
                  u'QW',
                  u'R1',
                  u'R2',
                  u'R3',
                  u'R5',
                  u'R6',
                  u'R7',
                  u'R8',
                  u'R9',
                  u'RA',
                  u'RB',
                  u'RC',
                  u'RD',
                  u'RE',
                  u'RG',
                  u'RH',
                  u'RL',
                  u'RM',
                  u'RN',
                  u'RP',
                  u'RQ',
                  u'RR',
                  u'RS',
                  u'RT',
                  u'RU',
                  u'RV',
                  u'RW',
                  u'RX',
                  u'RY',
                  u'RZ',
                  u'S2',
                  u'S3',
                  u'S4',
                  u'S5',
                  u'S6',
                  u'S7',
                  u'S8',
                  u'S9',
                  u'SA',
                  u'SB',
                  u'SC',
                  u'SD',
                  u'SE',
                  u'SG',
                  u'SH',
                  u'SI',
                  u'SJ',
                  u'SK',
                  u'SL',
                  u'SN',
                  u'SO',
                  u'SP',
                  u'SQ',
                  u'SR',
                  u'SS',
                  u'ST',
                  u'SU',
                  u'SW',
                  u'SX',
                  u'SY',
                  u'T1',
                  u'T2',
                  u'T3',
                  u'T6',
                  u'T7',
                  u'T9',
                  u'TE',
                  u'TG',
                  u'TK',
                  u'TL',
                  u'TM',
                  u'TN',
                  u'TP',
                  u'TQ',
                  u'TR',
                  u'TS',
                  u'TT',
                  u'TV',
                  u'UB',
                  u'UC',
                  u'UD',
                  u'UE',
                  u'UF',
                  u'UJ',
                  u'UL',
                  u'UN',
                  u'UP',
                  u'UR',
                  u'US',
                  u'UT',
                  u'UU',
                  u'UV',
                  u'UW',
                  u'UY',
                  u'UZ',
                  u'V1',
                  u'V2',
                  u'V3',
                  u'V4',
                  u'V5',
                  u'V6',
                  u'V7',
                  u'V8',
                  u'V9',
                  u'VA',
                  u'VB',
                  u'VD',
                  u'VF',
                  u'VG',
                  u'VK',
                  u'VL',
                  u'VM',
                  u'VN',
                  u'VP',
                  u'VQ',
                  u'VR',
                  u'VS',
                  u'VT',
                  u'VV',
                  u'VW',
                  u'VX',
                  u'VZ',
                  u'W2',
                  u'W3',
                  u'W4',
                  u'W5',
                  u'W6',
                  u'W7',
                  u'W8',
                  u'W9',
                  u'WA',
                  u'WB',
                  u'WC',
                  u'WD',
                  u'WE',
                  u'WF',
                  u'WG',
                  u'WH',
                  u'WJ',
                  u'WK',
                  u'WL',
                  u'WM',
                  u'WN',
                  u'WP',
                  u'WQ',
                  u'WR',
                  u'WS',
                  u'WT',
                  u'WU',
                  u'WW',
                  u'WX',
                  u'WY',
                  u'WZ',
                  u'X2',
                  u'X3',
                  u'X4',
                  u'X5',
                  u'X6',
                  u'X7',
                  u'X8',
                  u'X9',
                  u'XA',
                  u'XB',
                  u'XC',
                  u'XD',
                  u'XE',
                  u'XF',
                  u'XG',
                  u'XH',
                  u'XJ',
                  u'XK',
                  u'XM',
                  u'XN',
                  u'XP',
                  u'XQ',
                  u'XR',
                  u'XS',
                  u'XT',
                  u'XU',
                  u'XV',
                  u'XX',
                  u'XY',
                  u'Y3',
                  u'Y5',
                  u'Y6',
                  u'Y8',
                  u'YA',
                  u'YB',
                  u'YC',
                  u'YD',
                  u'YF',
                  u'YG',
                  u'YH',
                  u'YJ',
                  u'YL',
                  u'YN',
                  u'YR',
                  u'YS',
                  u'YT',
                  u'YU',
                  u'YV',
                  u'YW',
                  u'YX',
                  u'YY',
                  u'YZ',
                  u'Z2',
                  u'Z3',
                  u'Z4',
                  u'Z5',
                  u'Z6',
                  u'Z7',
                  u'Z8',
                  u'ZA',
                  u'ZB',
                  u'ZC',
                  u'ZD',
                  u'ZE',
                  u'ZF',
                  u'ZG',
                  u'ZH',
                  u'ZJ',
                  u'ZK',
                  u'ZL',
                  u'ZM',
                  u'ZN',
                  u'ZP',
                  u'ZQ',
                  u'ZR',
                  u'ZS',
                  u'ZT',
                  u'ZU',
                  u'ZW',
                  u'ZX']},
'name' : {   'alias': u'name',
    'default': None,
    'multiValued': True,
    'name': u'name',
    'values': [   u'Aggregate_AnalysisFeatures',
                  u'CopyNumber_Clustering_CNMF',
                  u'CopyNumber_Clustering_CNMF_thresholded',
                  u'CopyNumber_Gistic2',
                  u'CopyNumberLowPass_Gistic2',
                  u'Correlate_Clinical_vs_CopyNumber_Arm',
                  u'Correlate_Clinical_vs_CopyNumber_Focal',
                  u'Correlate_Clinical_vs_Methylation',
                  u'Correlate_Clinical_vs_miR',
                  u'Correlate_Clinical_vs_miRseq',
                  u'Correlate_Clinical_vs_Molecular_Subtypes',
                  u'Correlate_Clinical_vs_mRNA',
                  u'Correlate_Clinical_vs_mRNAseq',
                  u'Correlate_Clinical_vs_Mutation',
                  u'Correlate_Clinical_vs_Mutation_APOBEC_Categorical',
                  u'Correlate_Clinical_vs_Mutation_APOBEC_Continuous',
                  u'Correlate_Clinical_vs_MutationRate',
                  u'Correlate_Clinical_vs_RPPA',
                  u'Correlate_CopyNumber_vs_miR',
                  u'Correlate_CopyNumber_vs_mRNA',
                  u'Correlate_CopyNumber_vs_mRNAseq',
                  u'Correlate_Methylation_vs_mRNA',
                  u'Correlate_molecularSubtype_vs_CopyNumber_Arm',
                  u'Correlate_molecularSubtype_vs_CopyNumber_Focal',
                  u'Correlate_molecularSubtype_vs_Mutation',
                  u'Correlate_mRNAseq_vs_Mutation_APOBEC',
                  u'Methylation_Clustering_CNMF',
                  u'miR_Clustering_CNMF',
                  u'miR_Clustering_Consensus',
                  u'miR_Clustering_Consensus_Plus',
                  u'miR_FindDirectTargets',
                  u'miRseq_Clustering_CNMF',
                  u'miRseq_Clustering_Consensus',
                  u'miRseq_Clustering_Consensus_Plus',
                  u'miRseq_FindDirectTargets',
                  u'miRseq_Mature_Clustering_CNMF',
                  u'miRseq_Mature_Clustering_Consensus',
                  u'miRseq_Mature_Clustering_Consensus_Plus',
                  u'mRNA_Clustering_CNMF',
                  u'mRNA_Clustering_Consensus',
                  u'mRNA_Clustering_Consensus_Plus',
                  u'mRNAseq_Clustering_CNMF',
                  u'mRNAseq_Clustering_Consensus',
                  u'mRNAseq_Clustering_Consensus_Plus',
                  u'Mutation_APOBEC',
                  u'Mutation_Assessor',
                  u'Mutation_CHASM',
                  u'MutSig2.0',
                  u'MutSig2CV',
                  u'MutSigCV',
                  u'MutSigNozzleReport1.5',
                  u'MutSigNozzleReport2.0',
                  u'MutSigNozzleReport2CV',
                  u'MutSigNozzleReportCV',
                  u'MutSigNozzleReportMerged',
                  u'Pathway_FindEnrichedGenes',
                  u'Pathway_GSEA_mRNAseq',
                  u'Pathway_Hotnet',
                  u'Pathway_Overlaps_MSigDB_MutSig2CV',
                  u'Pathway_Paradigm_mRNA',
                  u'Pathway_Paradigm_mRNA_And_Copy_Number',
                  u'Pathway_Paradigm_RNASeq',
                  u'Pathway_Paradigm_RNASeq_And_Copy_Number',
                  u'RPPA_Clustering_CNMF',
                  u'RPPA_Clustering_Consensus',
                  u'RPPA_Clustering_Consensus_Plus']},
'level' : {   'alias': u'level',
    'default': None,
    'multiValued': True,
    'name': u'level',
    'values': [1, 2, 3, 4]},
'column' : {   'alias': u'column',
    'default': None,
    'multiValued': True,
    'name': u'column',
    'values': [   u'Comma separated list of which data columns/fields to return.']},
'sort_by' : {   'alias': u'sort_by',
    'default': u'cohort',
    'multiValued': False,
    'name': u'sort_by',
    'values': [   u'tcga_participant_barcode',
                  u'cohort',
                  u'gene',
                  u'protocol',
                  u'sample_type']},
'q' : {   'alias': u'q',
    'default': None,
    'multiValued': False,
    'name': u'q',
    'values': [u'Only return results with Q-value <= given threshold.']},
'Exclude' : {   'alias': u'Exclude',
    'default': None,
    'multiValued': True,
    'name': u'Exclude',
    'values': [   u'Comma separated list of TCGA participants, identified by barcodes such as TCGA-GF-A4EO, denoting samples to exclude from computation.']},
'gene' : {   'alias': u'gene',
    'default': None,
    'multiValued': True,
    'name': u'gene',
    'values': [u'Comma separated list of gene name(s).']},
'page' : {   'alias': u'page',
    'default': 1,
    'multiValued': True,
    'name': u'page',
    'values': [   u'Which page (slice) of entire results set should be returned. ']},
}  # }}}

ParamAliases = {   #  {{{
'cde' : 'cde_name',
'barcode' : 'tcga_participant_barcode',
'cde_name' : 'cde',
'fh_cde_name' : 'fh_cde',
'tcga_participant_barcode' : 'barcode',
'fh_cde' : 'fh_cde_name',
}  # }}}

fbHLMap = {   #  {{{
'Metadata.Patients' : {   'name': 'patients', 'params': {   'required': [], 'semiReq': []}},
'Metadata.Centers' : {   'name': 'centers', 'params': {   'required': [], 'semiReq': []}},
'Metadata.ClinicalNames' : {   'name': 'clinical_names', 'params': {   'required': [], 'semiReq': []}},
'Metadata.MAFColNames' : {   'name': 'maf_colnames', 'params': {   'required': [], 'semiReq': []}},
'Metadata.SampleTypes' : {   'name': 'sampletypes', 'params': {   'required': [], 'semiReq': []}},
'Metadata.SampleTypeBarcode' : {   'name': 'barcode2type',
    'params': {   'required': [u'TCGA_Barcode'], 'semiReq': []}},
'Samples.miRSeq' : {   'name': 'mirseq', 'params': {   'required': [], 'semiReq': [u'mir']}},
'Analyses.MutationMAF' : {   'name': 'maf',
    'params': {   'required': [], 'semiReq': [u'cohort', u'gene', 'barcode']}},
'Metadata.Platforms' : {   'name': 'platforms', 'params': {   'required': [], 'semiReq': []}},
'Analyses.MutationSMG' : {   'name': 'smg', 'params': {   'required': [], 'semiReq': [u'cohort', u'gene']}},
'Samples.Clinical' : {   'name': 'clinical',
    'params': {   'required': [], 'semiReq': [u'cohort', 'barcode', 'cde']}},
'Metadata.HeartBeat' : {   'name': 'heartbeat', 'params': {   'required': [], 'semiReq': []}},
'Analyses.CopyNumberGenesFocal' : {   'name': 'cn_genes_focal',
    'params': {   'required': [], 'semiReq': [u'gene', 'barcode']}},
'Metadata.SampleTypeCode' : {   'name': 'samplecode2type', 'params': {   'required': [u'code'], 'semiReq': []}},
'Metadata.TSSites' : {   'name': u'tssites', 'params': {   'required': [], 'semiReq': []}},
'Analyses.CopyNumberGenesAll' : {   'name': 'cn_genes_all',
    'params': {   'required': [], 'semiReq': [u'gene', 'barcode']}},
'Samples.mRNASeq' : {   'name': 'mrnaseq', 'params': {   'required': [], 'semiReq': [u'gene']}},
'Analyses.mRNASeqQuartiles' : {   'name': 'mrnaseq_quartiles', 'params': {   'required': [u'gene'], 'semiReq': []}},
'Analyses.FeatureTable' : {   'name': 'featuretable', 'params': {   'required': [], 'semiReq': [u'cohort']}},
'Metadata.Cohorts' : {   'name': 'cohorts', 'params': {   'required': [], 'semiReq': []}},
'Metadata.Counts' : {   'name': 'counts', 'params': {   'required': [], 'semiReq': []}},
'Metadata.ClinicalNames_FH' : {   'name': 'clinical_names_fh', 'params': {   'required': [], 'semiReq': []}},
'Metadata.Dates' : {   'name': 'dates', 'params': {   'required': [], 'semiReq': []}},
'Samples.Clinical_FH' : {   'name': 'clinical_fh',
    'params': {   'required': [], 'semiReq': [u'cohort', 'barcode', 'fh_cde']}},
'Metadata.Cohort' : {   'name': 'cohort'},
'Analyses.CopyNumberGenesDeleted' : {   'name': 'cn_genes_del',
    'params': {   'required': [], 'semiReq': [u'cohort', u'gene']}},
'Metadata.SampleTypeShortLetterCode' : {   'name': 'sampletype2code',
    'params': {   'required': [u'short_letter_code'], 'semiReq': []}},
'Analyses.Reports' : {   'name': 'reports', 'params': {   'required': [], 'semiReq': []}},
'Analyses.CopyNumberGenesThresholded' : {   'name': 'cn_levels',
    'params': {   'required': [], 'semiReq': [u'gene', 'barcode']}},
'Analyses.CopyNumberGenesAmplified' : {   'name': 'cn_genes_amp',
    'params': {   'required': [], 'semiReq': [u'cohort', u'gene']}},
'Archives.StandardData' : {   'name': 'stddata', 'params': {   'required': [], 'semiReq': []}},
}  # }}}
