get.mutual.heatmap <- function(x,y,sig.gene,cut,title,rowTF,colTF,n.color) {
        gene.set <- colnames(x)
        n.gene <- length(gene.set)
        gene.set <- colnames(x)
        n.gene <- length(gene.set)

	z <- dist(t(-log10(x)),method="euclidian")
        hc0 <- hclust(z,method="ward")
        ordering <- hc0$order
        x <- x[ordering,ordering]
        y <- y[ordering,ordering]
        gene.set <- gene.set[ordering]

        x[is.na(x)] <- 1
        y[is.na(y)] <- 1

        z <- array(1,dim=c(n.gene,n.gene))
        z[upper.tri(z)] <- x[upper.tri(x)]
        z[lower.tri(z)] <- y[lower.tri(y)]
        colnames(z) <- gene.set
        rownames(z) <- gene.set

        mat <- z[gene.set %in% sig.gene,gene.set %in% sig.gene]
        mat <- as.matrix(mat)
        mat <- apply(mat,1:2,function(x) ifelse(-log10(x) > cut,cut,-log10(x)))
        mat[upper.tri(mat)] <- -mat[upper.tri(mat)]

        s0 <- 0.75
        s1 <- 1.25
        s2 <- 2.0
        par(cex.main=s2)
        heatmap.3(as.matrix(mat),col=redblue(n.color),scale="none",key=T,symkey=F,Colv=colTF,Rowv=rowTF,
                dendrogram="none",labCol=rownames(mat),labRow=rownames(mat),keysize=s0,
                trace="none",density.info="none",cexRow=s1,cexCol=s1,KeyValueName="-Log10(p-value)",
                main=paste(title,sep=" "),ylab="",margin=c(5,5),symbreaks=T)
}

fisher.simple.test <- function(mut.mat) {
	sample.set <- rownames(mut.mat)
	gene.set <- colnames(mut.mat)
        n.gene <- length(gene.set)
	n.sample <- length(sample.set)

        f.mat <- array(0,dim=c(2,2))
        p.val <- array(0,dim=c(n.gene,n.gene))
        fisher.exc <- array(1,dim=c(n.gene,n.gene))
        fisher.occ <- array(1,dim=c(n.gene,n.gene))
        for (i in 1:n.gene) {
        for (j in 1:n.gene) {
		if (i == j) next
                fisher.exc[i,j] <- 0
                fisher.occ[i,j] <- 0
                mat <- as.matrix(mut.mat[,match(c(gene.set[i],gene.set[j]),colnames(mut.mat),nomatch=0)])
                f.mat[1,1] <- sum(mat[,1] != 0 & mat[,2] != 0)
                f.mat[1,2] <- sum(mat[,1] != 0 & mat[,2] == 0)
                f.mat[2,1] <- sum(mat[,1] == 0 & mat[,2] != 0)
                f.mat[2,2] <- sum(mat[,1] == 0 & mat[,2] == 0)
		fisher.exc[i,j] <- fisher.test(f.mat, workspace = 200000, hybrid = FALSE,
                        control = list(), or = 1, alternative = "less",
                        conf.int = TRUE, conf.level = 0.95,
                        simulate.p.value = FALSE, B = 2000)$p.value
		fisher.occ[i,j] <- fisher.test(f.mat, workspace = 200000, hybrid = FALSE,
                        control = list(), or = 1, alternative = "greater",
                        conf.int = TRUE, conf.level = 0.95,
                        simulate.p.value = FALSE, B = 2000)$p.value
                }
        }
	cat(i,i,'\n')
	colnames(fisher.exc) <- gene.set
	rownames(fisher.exc) <- gene.set
	colnames(fisher.occ) <- gene.set
	rownames(fisher.occ) <- gene.set
	return(list(fisher.exc,fisher.occ))
}
