

### This code was developed by Hailei Zhang and Jaegil Kim from Broad GDAC group 
####This function is to create the cooccurence figure of copy number and muation combined data 
####The input files are matrix which were generated form plot_cn_arm_cooccurrence.R,plot_cn_focal_cooccurrence.R and plot_mutation_cooccurrence.R


library(gplots)
library(RColorBrewer)
### this function is used to calcuate the fisher exact test within a matrix
source("./script/fisher.exact.test.combined.R")
### this function is used to generate the heatmap figures 
source("./script/heatmap.3.modified.R")


creatalleventsfigure <- function(event.mutation,event.arm,event.focal,tumor) {
  
  ### merged all the events ###############################
  
  set.sample1 <- colnames(event.mutation)
  set.sample2 <- colnames(event.arm)
  set.sample3 <- colnames(event.focal)
  overlap.samples <- intersect(intersect(set.sample1,set.sample2),set.sample3)
  
  event.mutation <- event.mutation[,overlap.samples]
  event.arm <- event.arm[,overlap.samples]
  event.focal <- event.focal[,overlap.samples]
  event.all <- rbind(event.mutation,event.arm,event.focal)
  
  #+++++++ calculate correlation based on event matrix +++++++++++
  cut.sample <- 0.01
  cut.heatmap.default <- 4
  fisher <- fisher.simple.test(t(event.all))
  maxp <- max(-log10(unlist(fisher)))
  cut.heatmap <- ifelse(maxp >= cut.heatmap.default,cut.heatmap.default,round(maxp))
  
  ##### draw exclusiveness and cocurrence figure on copy number focal event###########
  png(file=paste(tumor,'fisher.all.correlation.png',sep="."),width=3000,height=3000)
  get.mutual.heatmap(fisher[[1]],fisher[[2]],colnames(fisher[[1]]),cut.heatmap,"Correlations in Mutation and SCNAs",F,F,50)
  dev.off()
  
}

#creatalleventsfigure(event.mutation,event.arm,event.focal)
