
library(gplots)
library(RColorBrewer)
### this function is used to calcuate the fisher exact test within a matrix
source("./script/fisher.exact.test.combined.R")
### this function is used to generate the heatmap figures 
source("./script/heatmap.3.modified.R")

#### this function is used to read the feature table and obtain the copy number and mutation info and then do preprocess the matrix, 
#####calculate the fisher exact test and then draw the covarance figure


#### function to pull out mutation data from the feature table and plot the co-occuring figure of somatic muation genes
createmutationfigure <- function(feature.file,tumor){
  ## read the feature file 
  feature.table.original <- read.table(feature.file,header=T,comment='',sep='\t',as.is=T,na.strings='NA',stringsAsFactors=F,check.names=F)
  ## create the feature table only with samples and features
  sample.index <- nchar(feature.table.original[,1]) == 12
  feature.table <- feature.table.original[sample.index,]
  
  sample.name <- feature.table[,1]
  rownames(feature.table) <- sample.name
    
##### preprocess for mutation data
  genematrix <- feature.table[,grep("SMG_mutsig",colnames(feature.table))]
  genematrix <- genematrix[,colSums(genematrix,na.rm=T) != 0]
  colnames(genematrix) <- as.character(sapply(colnames(genematrix),function(x) strsplit(x,"_")[[1]][3]))
  genematrix <- genematrix[,!duplicated(colnames(genematrix))]
  genematrix <- t(genematrix)
 
########### remove samples with all NA values 
  index1 <- colSums(is.na(genematrix)) != nrow(genematrix)
  mutation <- data.frame(genematrix,check.names=F)
  mutation <- mutation[,index1]
  
########### create the event matrix 1:mutation, 0: wild type for cooccurrence figure
  event.mutation <- apply(mutation,1:2,function(x) ifelse(x > 1,1,0))
  
  #+++++++ calculate correlation based on event matrix +++++++++++
  cut.sample <- 0.01
  cut.heatmap.default <- 4
  ## fisher exact test is used to calculate the association withon two pair of mutations: the pvalue with exclusiveness and cocurrence will be returned.
  fisher <- fisher.simple.test(t(event.mutation))
  maxp <- max(-log10(unlist(fisher)))
  cut.heatmap <- ifelse(maxp >= cut.heatmap.default,cut.heatmap.default,round(maxp))
  
  ##### draw exclusiveness and cocurrence figure on mutaion data###########
  png(file=paste(tumor,'fisher.mutation.correlation.png',sep="."),width=1000,height=1000)
  get.mutual.heatmap(fisher[[1]],fisher[[2]],colnames(fisher[[1]]),cut.heatmap,"Correlations in Somatic Mutations",F,F,50)
  dev.off()
  return(event.mutation)
}

#createmutationfigure(feature.file="./CESC-TP.samplefeatures.txt",tumor="CESC-TP")
