
# This script is for end-users to test their FireBrowse Python client bindings,
# when installed from .zip file (instead of the canonical 'pip install').  As
# such, PLEASE NOTE that this is NOT part of the internal/developer test suite.

from __future__ import print_function
import firebrowse as fb

# Test 1: lowlevel heartbeat
print(fb.Metadata().HeartBeat())

import fbget

# Test 2: highlevel report func
print(fbget.reports(name="CopyNumber_Gistic2", cohort="acc", date="2014_10_17", format="json"))
print()

# Test 3: highlevel cohorts func, pruned down
cohorts = fbget.cohorts().split('\n')
adenoCarcinomas = filter(lambda c: "adenocarcinoma" in c, cohorts)
print("\n".join(adenoCarcinomas))
print()

# Test 4: show help for highlevel centers func
fbget.centers('help')
