
# This file is part of fbget: Python wrappers for the FireBrowse RESTful api
# Autogenerated on 2015_05_18 15:14:12 EDT

__version__ = '0.1.2'

SupportedParameters = {   #  {{{
'code' : {   'alias': u'code',
    'default': None,
    'multiValued': True,
    'name': u'code',
    'values': [   u'01',
                  u'02',
                  u'03',
                  u'04',
                  u'05',
                  u'06',
                  u'07',
                  u'08',
                  u'09',
                  u'10',
                  u'11',
                  u'12',
                  u'13',
                  u'14',
                  u'20',
                  u'40',
                  u'50',
                  u'60',
                  u'61']},
'protocol' : {   'alias': u'protocol',
    'default': u'RSEM',
    'multiValued': True,
    'name': u'protocol',
    'values': [u'RPKM', u'RSEM']},
'tier1_cde_name' : {   'alias': u'tier1_cde_name',
    'default': None,
    'multiValued': True,
    'name': u'tier1_cde_name',
    'values': [   u'age_at_diagnosis',
                  u'ajcc_tumor_pathologic_pt',
                  u'batch_number',
                  u'Breslow_thickness',
                  u'cause_of_death',
                  u'cervix_suv_results',
                  u'chemo_concurrent_type',
                  u'chemotherapy',
                  u'completeness_of_resection',
                  u'corpus_involvement',
                  u'date_of_initial_pathologic_diagnosis',
                  u'days_to_death',
                  u'days_to_last_followup',
                  u'days_to_last_known_alive',
                  u'days_to_preop_psa',
                  u'days_to_psa',
                  u'days_to_submitted_specimen_dx',
                  u'days_to_tumor_recurrence',
                  u'dcc_upload_date',
                  u'ethnicity',
                  u'examinations_examination_karnofskyperformancescore',
                  u'extrathyroidal_extension',
                  u'fedpet_or_ct_results',
                  u'gender',
                  u'gleason_score',
                  u'gleason_score_combined',
                  u'gleason_score_primary',
                  u'gleason_score_secondary',
                  u'height_cm_at_diagnosis',
                  u'highest_gleason_score',
                  u'histological_type',
                  u'history_hormonal_contraceptives_use',
                  u'hysterectomy_type',
                  u'initial_pathologic_dx_year',
                  u'karnofsky_performance_score',
                  u'keratinization_squamous_cell',
                  u'lymph_node_location',
                  u'lymph_nodes_examined',
                  u'lymph_nodes_examined_he_count',
                  u'lymphovascular_involvement',
                  u'melanoma_primary_known',
                  u'melanoma_ulceration',
                  u'menopause_status',
                  u'multifocality',
                  u'neoplasm_diseasestage',
                  u'neoplasm_histologic_grade',
                  u'number_of_lymph_nodes',
                  u'number_pack_years_smoked',
                  u'pathology_M_stage',
                  u'pathology_N_stage',
                  u'pathology_T_stage',
                  u'patient_agebegansmokinginyears',
                  u'patient_cervicalcarcinomapelvicextensiontext',
                  u'patient_patientpregnancyspontaneousabortioncount',
                  u'patient_patientpregnancytherapeuticabortioncount',
                  u'patient_tumor_recurrence_status',
                  u'pos_lymph_node_location',
                  u'pregnancies_count_ectopic',
                  u'pregnancies_count_live_birth',
                  u'pregnancies_count_stillbirth',
                  u'pregnancies_count_total',
                  u'primary_site_of_disease',
                  u'psa_result_preop',
                  u'psa_value',
                  u'race',
                  u'radiation_adjuvant_units',
                  u'radiation_exposure',
                  u'radiation_therapy',
                  u'radiation_therapy_site',
                  u'radiation_therapy_status',
                  u'radiation_therapy_type',
                  u'radiation_total_dose',
                  u'radiation_treatment_adjuvant',
                  u'radiations_radiation_regimenindication',
                  u'stage_event_clinical_stage',
                  u'tobacco_smoking_history',
                  u'tobacco_smoking_pack_years_smoked',
                  u'tobacco_smoking_year_stopped',
                  u'tumor_grade',
                  u'tumor_sample_procurement_country',
                  u'tumor_size',
                  u'tumor_stage',
                  u'tumor_status',
                  u'vital_status',
                  u'weight_kg_at_diagnosis',
                  u'year_of_tobacco_smoking_onset']},
'page_size' : {   'alias': u'page_size',
    'default': 250,
    'multiValued': True,
    'name': u'page_size',
    'values': [u'Number of records per page of results.  Maximum is 2000.']},
'short_letter_code' : {   'alias': u'short_letter_code',
    'default': None,
    'multiValued': True,
    'name': u'short_letter_code',
    'values': [   u'TP',
                  u'TR',
                  u'TB',
                  u'TRBM',
                  u'TAP',
                  u'TM',
                  u'TAM',
                  u'THOC',
                  u'TBM',
                  u'NB',
                  u'NT',
                  u'NBC',
                  u'NEBV',
                  u'NBM',
                  u'CELLC',
                  u'TRB',
                  u'CELL',
                  u'XP',
                  u'XCL']},
'cohort' : {   'alias': u'cohort',
    'default': None,
    'multiValued': True,
    'name': u'cohort',
    'values': [   u'ACC',
                  u'BLCA',
                  u'BRCA',
                  u'CESC',
                  u'CHOL',
                  u'COAD',
                  u'COADREAD',
                  u'DLBC',
                  u'ESCA',
                  u'FPPP',
                  u'GBM',
                  u'GBMLGG',
                  u'HNSC',
                  u'KICH',
                  u'KIPAN',
                  u'KIRC',
                  u'KIRP',
                  u'LAML',
                  u'LGG',
                  u'LIHC',
                  u'LUAD',
                  u'LUSC',
                  u'MESO',
                  u'OV',
                  u'PAAD',
                  u'PCPG',
                  u'PRAD',
                  u'READ',
                  u'SARC',
                  u'SKCM',
                  u'STAD',
                  u'STES',
                  u'TGCT',
                  u'THCA',
                  u'THYM',
                  u'UCEC',
                  u'UCS',
                  u'UVM']},
'TCGA_Barcode' : {   'alias': u'TCGA_Barcode',
    'default': None,
    'multiValued': False,
    'name': u'TCGA_Barcode',
    'values': [   u'Enter a single TCGA barcode, of any form: e.g. TCGA-GF-A4EO-06 or TCGA-EL-A3D5-01A-22D-A202-08']},
'sample_type' : {   'alias': u'sample_type',
    'default': None,
    'multiValued': True,
    'name': u'sample_type',
    'values': [   u'NB',
                  u'NBC',
                  u'NBM',
                  u'NT',
                  u'TAM',
                  u'TAP',
                  u'TB',
                  u'TM',
                  u'TP',
                  u'TR']},
'totals' : {   'alias': u'totals',
    'default': True,
    'multiValued': False,
    'name': u'totals',
    'values': [u'Output an entry providing the totals for each data type.']},
'platform' : {   'alias': u'platform',
    'default': None,
    'multiValued': True,
    'name': u'platform',
    'values': [   u'454',
                  u'ABI',
                  u'AgilentG4502A_07',
                  u'AgilentG4502A_07_1',
                  u'AgilentG4502A_07_2',
                  u'AgilentG4502A_07_3',
                  u'bio',
                  u'biotab',
                  u'CGH-1x1M_G4447A',
                  u'diagnostic_images',
                  u'fh_analyses',
                  u'fh_reports',
                  u'fh_stddata',
                  u'Genome_Wide_SNP_6',
                  u'GenomeWideSNP_5',
                  u'H-miRNA_8x15K',
                  u'H-miRNA_8x15Kv2',
                  u'H-miRNA_EarlyAccess',
                  u'H-miRNA_G4470A',
                  u'HG-CGH-244A',
                  u'HG-CGH-415K_G4124A',
                  u'HG-U133_Plus_2',
                  u'HG-U133A_2',
                  u'HT_HG-U133A',
                  u'HuEx-1_0-st-v2',
                  u'Human1MDuo',
                  u'HumanHap550',
                  u'HumanMethylation27',
                  u'HumanMethylation450',
                  u'IlluminaDNAMethylation_OMA002_CPI',
                  u'IlluminaDNAMethylation_OMA003_CPI',
                  u'IlluminaGA_DNASeq',
                  u'IlluminaGA_DNASeq_automated',
                  u'IlluminaGA_DNASeq_Cont',
                  u'IlluminaGA_DNASeq_Cont_automated',
                  u'IlluminaGA_DNASeq_Cont_curated',
                  u'IlluminaGA_DNASeq_curated',
                  u'IlluminaGA_miRNASeq',
                  u'IlluminaGA_mRNA_DGE',
                  u'IlluminaGA_RNASeq',
                  u'IlluminaGA_RNASeqV2',
                  u'IlluminaGG',
                  u'IlluminaHiSeq_DNASeq',
                  u'IlluminaHiSeq_DNASeq_automated',
                  u'IlluminaHiSeq_DNASeq_Cont',
                  u'IlluminaHiSeq_DNASeq_Cont_automated',
                  u'IlluminaHiSeq_DNASeq_Cont_curated',
                  u'IlluminaHiSeq_DNASeq_curated',
                  u'IlluminaHiSeq_DNASeqC',
                  u'IlluminaHiSeq_miRNASeq',
                  u'IlluminaHiSeq_mRNA_DGE',
                  u'IlluminaHiSeq_RNASeq',
                  u'IlluminaHiSeq_RNASeqV2',
                  u'IlluminaHiSeq_TotalRNASeqV2',
                  u'IlluminaHiSeq_WGBS',
                  u'Mapping250K_Nsp',
                  u'Mapping250K_Sty',
                  u'MDA_RPPA_Core',
                  u'microsat_i',
                  u'minbio',
                  u'minbiotab',
                  u'Mixed_DNASeq',
                  u'Mixed_DNASeq_automated',
                  u'Mixed_DNASeq_Cont',
                  u'Mixed_DNASeq_Cont_automated',
                  u'Mixed_DNASeq_Cont_curated',
                  u'Mixed_DNASeq_curated',
                  u'pathology_reports',
                  u'SOLiD_DNASeq',
                  u'SOLiD_DNASeq_automated',
                  u'SOLiD_DNASeq_Cont',
                  u'SOLiD_DNASeq_Cont_automated',
                  u'SOLiD_DNASeq_Cont_curated',
                  u'SOLiD_DNASeq_curated',
                  u'tissue_images',
                  u'WHG-1x44K_G4112A',
                  u'WHG-4x44K_G4112F',
                  u'WHG-CGH_4x44B']},
'mir' : {   'alias': u'mir',
    'default': None,
    'multiValued': True,
    'name': u'mir',
    'values': [   u'Comma separated list of miR names (e.g. hsa-let-7b-5p,hsa-let-7a-1).']},
'type' : {   'alias': u'type',
    'default': None,
    'multiValued': True,
    'name': u'type',
    'values': [   u'Aggregate',
                  u'Clustering',
                  u'CopyNumber',
                  u'Correlations',
                  u'Expression',
                  u'Mutation',
                  u'Pathway']},
'data_type' : {   'alias': u'data_type',
    'default': None,
    'multiValued': True,
    'name': u'data_type',
    'values': [   u'Clinical',
                  u'CopyNumber',
                  u'LowPass',
                  u'MAF',
                  u'Methylation',
                  u'miR',
                  u'miRSeq',
                  u'mRNA',
                  u'mRNASeq',
                  u'RPPA',
                  u'WIG']},
'format' : {   'alias': u'format',
    'default': u'json',
    'multiValued': False,
    'name': u'format',
    'values': [u'json', u'tsv', u'csv']},
'tool' : {   'alias': u'tool',
    'default': u'miRseq_Mature_Preprocess',
    'multiValued': True,
    'name': u'tool',
    'values': [u'miRseq_Mature_Preprocess', u'miRseq_Preprocess']},
'barcode' : {   'alias': 'barcode',
    'default': None,
    'multiValued': True,
    'name': u'tcga_participant_barcode',
    'values': [   u'Comma separated list of TCGA participant barcodes (e.g. TCGA-GF-A4EO).']},
'rank' : {   'alias': u'rank',
    'default': None,
    'multiValued': False,
    'name': u'rank',
    'values': [u'Number of significant genes to return.']},
'date' : {   'alias': u'date',
    'default': u'2015_04_02',
    'multiValued': True,
    'name': u'date',
    'values': [   u'2015_04_02',
                  u'2014_10_17',
                  u'2014_07_15',
                  u'2014_04_16',
                  u'2014_01_15',
                  u'2013_09_23',
                  u'2013_05_23',
                  u'2013_04_21']},
'center' : {   'alias': u'center',
    'default': None,
    'multiValued': True,
    'name': u'center',
    'values': [   u'bcgsc.ca',
                  u'broad.mit.edu',
                  u'broadinstitute.org',
                  u'genome.wustl.edu',
                  u'hgsc.bcm.edu',
                  u'hms.harvard.edu',
                  u'hudsonalpha.org',
                  u'intgen.org',
                  u'jhu-usc.edu',
                  u'jhu.edu',
                  u'lbl.gov',
                  u'mdanderson.org',
                  u'mskcc.org',
                  u'nationwidechildrens.org',
                  u'pnl.gov',
                  u'rubicongenomics.com',
                  u'sanger.ac.uk',
                  u'systemsbiology.org',
                  u'ucsc.edu',
                  u'unc.edu',
                  u'vanderbilt.edu']},
'name' : {   'alias': u'name',
    'default': None,
    'multiValued': True,
    'name': u'name',
    'values': [   u'Aggregate_AnalysisFeatures',
                  u'CopyNumber_Clustering_CNMF',
                  u'CopyNumber_Clustering_CNMF_thresholded',
                  u'CopyNumber_Gistic2',
                  u'CopyNumberLowPass_Gistic2',
                  u'Correlate_Clinical_vs_CopyNumber_Arm',
                  u'Correlate_Clinical_vs_CopyNumber_Focal',
                  u'Correlate_Clinical_vs_Methylation',
                  u'Correlate_Clinical_vs_miR',
                  u'Correlate_Clinical_vs_miRseq',
                  u'Correlate_Clinical_vs_Molecular_Subtypes',
                  u'Correlate_Clinical_vs_mRNA',
                  u'Correlate_Clinical_vs_mRNAseq',
                  u'Correlate_Clinical_vs_Mutation',
                  u'Correlate_Clinical_vs_Mutation_APOBEC_Categorical',
                  u'Correlate_Clinical_vs_Mutation_APOBEC_Continuous',
                  u'Correlate_Clinical_vs_MutationRate',
                  u'Correlate_Clinical_vs_RPPA',
                  u'Correlate_CopyNumber_vs_miR',
                  u'Correlate_CopyNumber_vs_mRNA',
                  u'Correlate_CopyNumber_vs_mRNAseq',
                  u'Correlate_Methylation_vs_mRNA',
                  u'Correlate_molecularSubtype_vs_CopyNumber_Arm',
                  u'Correlate_molecularSubtype_vs_CopyNumber_Focal',
                  u'Correlate_molecularSubtype_vs_Mutation',
                  u'Correlate_mRNAseq_vs_Mutation_APOBEC',
                  u'Methylation_Clustering_CNMF',
                  u'miR_Clustering_CNMF',
                  u'miR_Clustering_Consensus',
                  u'miR_Clustering_Consensus_Plus',
                  u'miR_FindDirectTargets',
                  u'miRseq_Clustering_CNMF',
                  u'miRseq_Clustering_Consensus',
                  u'miRseq_Clustering_Consensus_Plus',
                  u'miRseq_FindDirectTargets',
                  u'miRseq_Mature_Clustering_CNMF',
                  u'miRseq_Mature_Clustering_Consensus',
                  u'miRseq_Mature_Clustering_Consensus_Plus',
                  u'mRNA_Clustering_CNMF',
                  u'mRNA_Clustering_Consensus',
                  u'mRNA_Clustering_Consensus_Plus',
                  u'mRNAseq_Clustering_CNMF',
                  u'mRNAseq_Clustering_Consensus',
                  u'mRNAseq_Clustering_Consensus_Plus',
                  u'Mutation_APOBEC',
                  u'Mutation_Assessor',
                  u'Mutation_CHASM',
                  u'MutSigNozzleReport1.5',
                  u'MutSigNozzleReport2.0',
                  u'MutSigNozzleReport2CV',
                  u'MutSigNozzleReportCV',
                  u'MutSigNozzleReportMerged',
                  u'Pathway_FindEnrichedGenes',
                  u'Pathway_GSEA_mRNAseq',
                  u'Pathway_Hotnet',
                  u'Pathway_Overlaps_MSigDB_MutSig2CV',
                  u'Pathway_Paradigm_mRNA',
                  u'Pathway_Paradigm_mRNA_And_Copy_Number',
                  u'Pathway_Paradigm_RNASeq',
                  u'Pathway_Paradigm_RNASeq_And_Copy_Number',
                  u'RPPA_Clustering_CNMF',
                  u'RPPA_Clustering_Consensus',
                  u'RPPA_Clustering_Consensus_Plus']},
'level' : {   'alias': u'level',
    'default': None,
    'multiValued': True,
    'name': u'level',
    'values': [1, 2, 3, 4]},
'column' : {   'alias': u'column',
    'default': None,
    'multiValued': True,
    'name': u'column',
    'values': [   u'Comma separated list of which data columns/fields to return.']},
'sort_by' : {   'alias': u'sort_by',
    'default': u'cohort',
    'multiValued': False,
    'name': u'sort_by',
    'values': [   u'tcga_participant_barcode',
                  u'cohort',
                  u'gene',
                  u'protocol',
                  u'sample_type']},
'q' : {   'alias': u'q',
    'default': None,
    'multiValued': False,
    'name': u'q',
    'values': [u'Only return results with Q-value <= given threshold.']},
'Exclude' : {   'alias': u'Exclude',
    'default': None,
    'multiValued': True,
    'name': u'Exclude',
    'values': [   u'Comma separated list of TCGA participants, identified by barcodes such as TCGA-GF-A4EO, denoting samples to exclude from computation.']},
'gene' : {   'alias': u'gene',
    'default': None,
    'multiValued': True,
    'name': u'gene',
    'values': [u'Comma separated list of gene name(s).']},
'page' : {   'alias': u'page',
    'default': 1,
    'multiValued': True,
    'name': u'page',
    'values': [   u'Which page (slice) of entire results set should be returned. ']},
}  # }}}

ParamAliases = {   #  {{{
'tcga_participant_barcode' : 'barcode',
'barcode' : 'tcga_participant_barcode',
}  # }}}

fbHLMap = {   #  {{{
'Metadata.Patients' : {   'name': u'patients', 'params': {   'required': [], 'semiReq': []}},
'Samples.ClinicalTier1' : {   'name': 'clinical',
    'params': {   'required': [], 'semiReq': [u'cohort', 'barcode']}},
'Metadata.Centers' : {   'name': 'centers', 'params': {   'required': [], 'semiReq': []}},
'Metadata.SampleTypes' : {   'name': 'sampletypes', 'params': {   'required': [], 'semiReq': []}},
'Metadata.SampleTypeBarcode' : {   'name': 'barcode2type',
    'params': {   'required': [u'TCGA_Barcode'], 'semiReq': []}},
'Samples.miRSeq' : {   'name': 'mirseq', 'params': {   'required': [], 'semiReq': [u'mir', 'barcode']}},
'Analyses.MutationMAF' : {   'name': 'maf',
    'params': {   'required': [], 'semiReq': [u'cohort', u'gene', 'barcode']}},
'Metadata.Platforms' : {   'name': 'platforms', 'params': {   'required': [], 'semiReq': []}},
'Analyses.MutationSMG' : {   'name': 'smg', 'params': {   'required': [], 'semiReq': [u'cohort']}},
'Metadata.HeartBeat' : {   'name': 'heartbeat', 'params': {   'required': [], 'semiReq': []}},
'Analyses.CopyNumberGenesFocal' : {   'name': 'cn_genes_focal',
    'params': {   'required': [], 'semiReq': [u'gene', 'barcode']}},
'Metadata.SampleTypeCode' : {   'name': 'samplecode2type', 'params': {   'required': [u'code'], 'semiReq': []}},
'Metadata.ClinicalTier1' : {   'name': 'clinical_names', 'params': {   'required': [], 'semiReq': []}},
'Analyses.CopyNumberGenesAll' : {   'name': 'cn_genes_all',
    'params': {   'required': [], 'semiReq': [u'gene', 'barcode']}},
'Samples.mRNASeq' : {   'name': 'mrnaseq',
    'params': {   'required': [], 'semiReq': [u'gene', 'barcode']}},
'Analyses.mRNASeqQuartiles' : {   'name': 'mrnaseq_quartiles', 'params': {   'required': [u'gene'], 'semiReq': []}},
'Analyses.FeatureTable' : {   'name': 'featuretable', 'params': {   'required': [], 'semiReq': [u'cohort']}},
'Metadata.Cohorts' : {   'name': 'cohorts', 'params': {   'required': [], 'semiReq': []}},
'Metadata.Counts' : {   'name': 'counts', 'params': {   'required': [], 'semiReq': [u'date']}},
'Metadata.Dates' : {   'name': 'dates', 'params': {   'required': [], 'semiReq': []}},
'Metadata.Cohort' : {   'name': 'cohort', 'params': {   'required': [u'cohort'], 'semiReq': []}},
'Analyses.CopyNumberGenesDeleted' : {   'name': 'cn_genes_del',
    'params': {   'required': [], 'semiReq': [u'cohort', u'gene']}},
'Metadata.SampleTypeShortLetterCode' : {   'name': 'sampletype2code',
    'params': {   'required': [u'short_letter_code'], 'semiReq': []}},
'Analyses.Reports' : {   'name': 'reports', 'params': {   'required': [], 'semiReq': []}},
'Analyses.CopyNumberGenesThresholded' : {   'name': 'cn_levels',
    'params': {   'required': [], 'semiReq': [u'gene', 'barcode']}},
'Analyses.CopyNumberGenesAmplified' : {   'name': 'cn_genes_amp',
    'params': {   'required': [], 'semiReq': [u'cohort', u'gene']}},
'Archives.StandardData' : {   'name': 'stddata', 'params': {   'required': [], 'semiReq': [u'date']}},
}  # }}}
