#! /bin/sh

# Simple-minded helper script to install fbget

pythonPath=`command -v python`
if [ -z "$pythonPath" ] ; then
    echo "You must have python (version 2.7.x) in your \$PATH"
    exit 1
fi

pkgdir=`python -c "from distutils.sysconfig import get_python_lib; print(get_python_lib())"`
cp -f firebrowse/fbget.py $pkgdir/.

python setup.py install

# In addition to installing the fbget Python package, setup.py ALSO installs
# a command line interface (CLI) tool named 'fbget' which enables fbget.py to
# be run directly from the O/S command line prompt, as 'fbget'.  We now verify
# that it's accessible in the caller's $PATH, and fix the installation if not.

fbgetPath=`command -v fbget`
if [ -n "$fbgetPath" ] ; then
    exit 0
fi

printf "\n\n\n"
echo "WARNING: fbget not in your \$PATH, now locating its true install location"
truePythonPath=`python -c "import sys; print sys.exec_prefix"`/bin

if [ -x $truePythonPath/fbget ] ; then
    echo "fbget was installed to $truePythonPath ..."
    echo "      ... but this is not in your \$PATH"
    pythonDir=`dirname $pythonPath`
    echo "To correct this I'll attempt to symlink fbget to"
    echo "          $pythonDir"
    echo "      ... which is where python lives in your \$PATH"
    ln -s $truePythonPath/fbget $pythonDir/.
    errMsg="Hmmm, that didn't seem to work, please contact your system admin"
else
    errMsg="Couldn't find fbget installation, please contact your system admin"
fi

fbgetPath=`command -v fbget`
if [ -z "$fbgetPath" ] ; then
    echo $errMsg
fi
